/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_632;
import net.minecraft.class_757;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.ILayerRenderFunction;
import slimeknights.mantle.client.screen.book.element.BookElement;

public class BookScreen
extends class_437 {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static final int PAGE_MARGIN = 8;
    public static final int PAGE_PADDING_TOP = 4;
    public static final int PAGE_PADDING_BOT = 4;
    public static final int PAGE_PADDING_LEFT = 8;
    public static final int PAGE_PADDING_RIGHT = 0;
    public static final float PAGE_SCALE = 1.0f;
    public static final int PAGE_WIDTH_UNSCALED = 206;
    public static final int PAGE_HEIGHT_UNSCALED = 200;
    public static final int PAGE_WIDTH = 182;
    public static final int PAGE_HEIGHT = 176;
    private ArrowButton previousArrow;
    private ArrowButton nextArrow;
    private ArrowButton backArrow;
    private ArrowButton indexArrow;
    public final BookData book;
    @Nullable
    private final Consumer<String> pageUpdater;
    @Nullable
    private final Consumer<?> bookPickup;
    private int page = -1;
    private int oldPage = -2;
    private final ArrayList<BookElement> leftElements = new ArrayList();
    private final ArrayList<BookElement> rightElements = new ArrayList();
    public AdvancementCache advancementCache;
    private double[] lastClick;
    private double[] lastDrag;
    private static final ILayerRenderFunction[] LAYERS = new ILayerRenderFunction[]{BookElement::draw, BookElement::drawOverlay};

    public BookScreen(class_2561 title, BookData book, String page, @Nullable Consumer<String> pageUpdater, @Nullable Consumer<?> bookPickup) {
        super(title);
        this.book = book;
        this.pageUpdater = pageUpdater;
        this.bookPickup = bookPickup;
        this.field_22787 = class_310.method_1551();
        this.field_22793 = this.field_22787.field_1772;
        this.advancementCache = new AdvancementCache();
        if (this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.field_3944.method_2869().method_2862((class_632.class_633)this.advancementCache);
        }
        this.openPage(book.findPageNumber(page, this.advancementCache));
    }

    public class_327 getFontRenderer() {
        class_327 fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = Objects.requireNonNull(this.field_22787).field_1772;
        }
        return fontRenderer;
    }

    private Vector3f splitRGB(int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        return new Vector3f(r, g, b);
    }

    private Vector4f splitRGBA(int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float a = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22787 == null) {
            return;
        }
        class_327 fontRenderer = this.getFontRenderer();
        if (debug) {
            int n = fontRenderer.method_1727("DEBUG") + 4;
            Objects.requireNonNull(fontRenderer);
            guiGraphics.method_25294(0, 0, n, 9 + 4, 0x55000000);
            guiGraphics.method_51433(fontRenderer, "DEBUG", 2, 2, -1, false);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        Vector3f coverColor = this.splitRGB(this.book.appearance.coverColor);
        if (this.page == -1) {
            this.renderCover(guiGraphics, coverColor);
        } else {
            class_4587 leftMatrix = new class_4587();
            leftMatrix.method_23760().method_23761().mul((Matrix4fc)guiGraphics.method_51448().method_23760().method_23761());
            leftMatrix.method_23760().method_23762().mul((Matrix3fc)guiGraphics.method_51448().method_23760().method_23762());
            class_4587 rightMatrix = new class_4587();
            rightMatrix.method_23760().method_23761().mul((Matrix4fc)guiGraphics.method_51448().method_23760().method_23761());
            rightMatrix.method_23760().method_23762().mul((Matrix3fc)guiGraphics.method_51448().method_23760().method_23762());
            this.drawerTransform(leftMatrix, false);
            this.drawerTransform(rightMatrix, true);
            leftMatrix.method_22905(1.0f, 1.0f, 1.0f);
            rightMatrix.method_22905(1.0f, 1.0f, 1.0f);
            boolean renderLeft = this.shouldRenderPage(this.page, false);
            boolean renderRight = this.shouldRenderPage(this.page, true);
            this.renderUnderLayer(guiGraphics, coverColor);
            if (renderLeft) {
                this.renderPageBackground(guiGraphics, false);
            }
            if (renderRight) {
                this.renderPageBackground(guiGraphics, true);
            }
            int leftMX = this.getMouseX(false);
            int rightMX = this.getMouseX(true);
            int mY = this.getMouseY();
            for (ILayerRenderFunction layer : LAYERS) {
                if (renderLeft) {
                    this.renderPageLayer(new class_332(class_310.method_1551(), leftMatrix, guiGraphics.method_51450()), leftMX, mY, partialTicks, this.leftElements, layer);
                }
                if (!renderRight) continue;
                this.renderPageLayer(new class_332(class_310.method_1551(), rightMatrix, guiGraphics.method_51450()), rightMX, mY, partialTicks, this.rightElements, layer);
            }
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private boolean shouldRenderPage(int pageNum, boolean rightSide) {
        if (!rightSide) {
            return pageNum != 0;
        }
        int fullPageCount = this.book.getFullPageCount(this.advancementCache);
        return this.page < fullPageCount - 1 || this.book.getPageCount(this.advancementCache) % 2 != 0;
    }

    private void renderCover(class_332 guiGraphics, Vector3f coverColor) {
        float scale;
        int width;
        class_4587 matrixStack = guiGraphics.method_51448();
        class_327 fontRenderer = this.getFontRenderer();
        int centerX = this.field_22789 / 2 - 103;
        int centerY = this.field_22790 / 2 - 100;
        RenderSystem.setShaderColor((float)coverColor.x(), (float)coverColor.y(), (float)coverColor.z(), (float)1.0f);
        guiGraphics.method_25290(this.book.appearance.getCoverTexture(), centerX, centerY, 0.0f, 0.0f, 206, 200, 512, 512);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.book.appearance.title.isEmpty()) {
            guiGraphics.method_25290(this.book.appearance.getCoverTexture(), centerX, centerY, 0.0f, 200.0f, 206, 200, 512, 512);
            matrixStack.method_22903();
            width = fontRenderer.method_1727(this.book.appearance.title);
            scale = class_3532.method_15363((float)(182.0f / (float)width), (float)0.0f, (float)2.5f);
            matrixStack.method_22905(scale, scale, 1.0f);
            String string = this.book.appearance.title;
            float f = (float)this.field_22789 / 2.0f / scale + 3.0f - (float)width / 2.0f;
            float f2 = (float)this.field_22790 / 2.0f;
            Objects.requireNonNull(fontRenderer);
            this.drawString(guiGraphics, fontRenderer, string, f, (f2 - 9.0f / 2.0f) / scale - 4.0f, this.book.appearance.getCoverTextColor(), true);
            matrixStack.method_22909();
        }
        if (!this.book.appearance.subtitle.isEmpty()) {
            matrixStack.method_22903();
            width = fontRenderer.method_1727(this.book.appearance.subtitle);
            scale = class_3532.method_15363((float)(182.0f / (float)width), (float)0.0f, (float)1.5f);
            matrixStack.method_22905(scale, scale, 1.0f);
            String string = this.book.appearance.subtitle;
            float f = (float)this.field_22789 / 2.0f / scale + 7.0f - (float)width / 2.0f;
            float f3 = (float)this.field_22790 / 2.0f + 100.0f;
            Objects.requireNonNull(fontRenderer);
            this.drawString(guiGraphics, fontRenderer, string, f, (f3 - (float)(9 * 2)) / scale, this.book.appearance.getCoverTextColor(), true);
            matrixStack.method_22909();
        }
    }

    public int drawString(class_332 guiGraphics, class_327 font, @Nullable String string, float i, float j, int k, boolean bl) {
        if (string == null) {
            return 0;
        }
        int l = font.method_27522(string, i, j, k, bl, guiGraphics.method_51448().method_23760().method_23761(), (class_4597)guiGraphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0, font.method_1726());
        guiGraphics.method_51744();
        return l;
    }

    private void renderUnderLayer(class_332 guiGraphics, Vector3f coverColor) {
        RenderSystem.setShaderColor((float)coverColor.x(), (float)coverColor.y(), (float)coverColor.z(), (float)1.0f);
        guiGraphics.method_25290(this.book.appearance.getBookTexture(), this.field_22789 / 2 - 206, this.field_22790 / 2 - 100, 0.0f, 0.0f, 412, 200, 512, 512);
    }

    private void renderPageBackground(class_332 guiGraphics, boolean rightSide) {
        Vector3f pageTint = this.splitRGB(this.book.appearance.getPageTint());
        RenderSystem.setShaderColor((float)pageTint.x(), (float)pageTint.y(), (float)pageTint.z(), (float)1.0f);
        if (!rightSide) {
            guiGraphics.method_25290(this.book.appearance.getBookTexture(), this.field_22789 / 2 - 206, this.field_22790 / 2 - 100, 0.0f, 200.0f, 206, 200, 512, 512);
        } else {
            guiGraphics.method_25290(this.book.appearance.getBookTexture(), this.field_22789 / 2, this.field_22790 / 2 - 100, 206.0f, 200.0f, 206, 200, 512, 512);
        }
    }

    private void renderPageLayer(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, List<BookElement> elements, ILayerRenderFunction layerFunc) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.book.appearance.getCoverTexture());
        class_327 font = this.getFontRenderer();
        for (BookElement element : elements) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            layerFunc.draw(element, guiGraphics, mouseX, mouseY, partialTicks, font);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.previousArrow = (ArrowButton)this.method_37063((class_364)new ArrowButton(this.book, 50, -50, ArrowButton.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.nextArrow = (ArrowButton)this.method_37063((class_364)new ArrowButton(this.book, -50, -50, ArrowButton.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.backArrow = (ArrowButton)this.method_37063((class_364)new ArrowButton(this.book, this.field_22789 / 2 - 9, this.field_22790 / 2 + 5 + 88, ArrowButton.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.indexArrow = (ArrowButton)this.method_37063((class_364)new ArrowButton(this.book, this.field_22789 / 2 - 206 - 9, this.field_22790 / 2 - 100, ArrowButton.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            this.openPage(this.book.findPageNumber("index.page1", this.advancementCache));
            this.oldPage = -2;
            this.buildPages();
        }));
        if (this.bookPickup != null) {
            int margin = 10;
            if (this.field_22790 / 2 + 100 + margin + 20 >= this.field_22790) {
                margin = 0;
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"lectern.take_book"), p_212998_1_ -> {
                this.method_25419();
                this.bookPickup.accept(null);
            }).method_46434(this.field_22789 / 2 - 98, this.field_22790 / 2 + 100 + margin, 196, 20).method_46431());
        }
        this.buildPages();
    }

    public void method_25393() {
        super.method_25393();
        this.previousArrow.field_22764 = this.page != -1;
        this.nextArrow.field_22764 = this.page + 1 < this.book.getFullPageCount(this.advancementCache);
        boolean bl = this.backArrow.field_22764 = this.oldPage >= -1;
        if (this.page == -1) {
            this.nextArrow.method_46421(this.field_22789 / 2 + 80);
            this.indexArrow.field_22764 = false;
        } else {
            this.previousArrow.method_46421(this.field_22789 / 2 - 184);
            this.nextArrow.method_46421(this.field_22789 / 2 + 165);
            SectionData index = this.book.findSection("index", this.advancementCache);
            this.indexArrow.field_22764 = index != null && (this.page - 1) * 2 + 2 > index.getPageCount();
        }
        this.previousArrow.method_46419(this.field_22790 / 2 + 75);
        this.nextArrow.method_46419(this.field_22790 / 2 + 75);
    }

    private void previousPage() {
        --this.page;
        if (this.page < -1) {
            this.page = -1;
        }
        this.oldPage = -2;
        this.buildPages();
    }

    private void nextPage() {
        ++this.page;
        int fullPageCount = this.book.getFullPageCount(this.advancementCache);
        if (this.page >= fullPageCount) {
            this.page = fullPageCount - 1;
        }
        this.oldPage = -2;
        this.buildPages();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        super.method_25404(keyCode, scanCode, modifiers);
        switch (keyCode) {
            case 65: 
            case 263: {
                this.previousPage();
                return true;
            }
            case 68: 
            case 262: {
                this.nextPage();
                return true;
            }
            case 292: {
                debug = !debug;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double unKnown1, double unKnown2, double scrollDelta) {
        if (scrollDelta < 0.0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0.0) {
            this.previousPage();
            return true;
        }
        return super.method_25401(scrollDelta, unKnown1, unKnown2);
    }

    public boolean method_25402(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        this.lastClick = new double[]{mouseX, mouseY};
        int oldPage = this.page;
        ImmutableList elementList = ImmutableList.copyOf(right ? this.rightElements : this.leftElements);
        for (BookElement element : elementList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.page == oldPage) continue;
            return true;
        }
        return super.method_25402(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean method_25406(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseReleased(mouseX, mouseY, mouseButton);
            ++i;
        }
        this.lastClick = null;
        this.lastDrag = null;
        return super.method_25406(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        if (this.lastClick != null) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mouseX, mouseY};
            }
            int i = 0;
            while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
                BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
                element.mouseDragged(this.lastClick[0], this.lastClick[1], mouseX, mouseY, this.lastDrag[0], this.lastDrag[1], button);
                ++i;
            }
            this.lastDrag = new double[]{mouseX, mouseY};
        }
        return true;
    }

    public void method_25432() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        if (this.pageUpdater != null) {
            Object pageStr = "";
            if (this.page >= 0) {
                PageData page;
                PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.advancementCache) : this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
                if (page == null) {
                    page = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
                }
                if (page != null && page.parent != null) {
                    pageStr = page.parent.name + "." + page.name;
                }
            }
            this.pageUpdater.accept((String)pageStr);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void drawerTransform(class_4587 matrixStack, boolean rightSide) {
        if (rightSide) {
            matrixStack.method_46416((float)(this.field_22789 / 2 + 0 + 8), (float)(this.field_22790 / 2 - 100 + 4 + 8), 0.0f);
        } else {
            matrixStack.method_46416((float)(this.field_22789 / 2 - 206 + 8 + 8), (float)(this.field_22790 / 2 - 100 + 4 + 8), 0.0f);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.field_22789 / 2 + 0 + 8;
        }
        return this.field_22789 / 2 - 206 + 8 + 8;
    }

    protected float topOffset() {
        return this.field_22790 / 2 - 100 + 4 + 8;
    }

    protected int getMouseX(boolean rightSide) {
        assert (this.field_22787 != null);
        return (int)((class_310.method_1551().field_1729.method_1603() * (double)this.field_22789 / (double)this.field_22787.method_22683().method_4480() - (double)this.leftOffset(rightSide)) / 1.0);
    }

    protected int getMouseY() {
        assert (this.field_22787 != null);
        return (int)((class_310.method_1551().field_1729.method_1604() * (double)this.field_22790 / (double)this.field_22787.method_22683().method_4507() - 1.0 - (double)this.topOffset()) / 1.0);
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.advancementCache)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public List<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : Collections.emptyList());
    }

    public void openCover() {
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    private void buildPages() {
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.advancementCache);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    public static class AdvancementCache
    implements class_632.class_633 {
        private final HashMap<class_161, class_167> progress = new HashMap();
        private final HashMap<class_2960, class_161> nameCache = new HashMap();

        @Nullable
        public class_167 getProgress(String id) {
            return this.getProgress(this.getAdvancement(id));
        }

        @Nullable
        public class_167 getProgress(class_161 advancement) {
            return this.progress.get(advancement);
        }

        public class_161 getAdvancement(String id) {
            return this.nameCache.get(new class_2960(id));
        }

        public void method_2865(class_161 advancement, class_167 advancementProgress) {
            this.progress.put(advancement, advancementProgress);
        }

        public void method_2866(@Nullable class_161 advancement) {
        }

        public void method_723(class_161 advancement) {
            this.nameCache.put(advancement.method_688(), advancement);
        }

        public void method_720(class_161 advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.method_688());
        }

        public void method_721(class_161 advancement) {
            this.nameCache.put(advancement.method_688(), advancement);
        }

        public void method_719(class_161 advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.method_688());
        }

        public void method_722() {
            this.progress.clear();
            this.nameCache.clear();
        }
    }
}

